#pragma GCC optimizez("Ofast,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,popcnt,lzcnt")

#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <set>
#include <array>
#include <cassert>

using namespace std;

using ll = long long;

pair<ll, ll> inter(pair<ll, ll> a, pair<ll, ll> b)
{
    return {max(a.first, b.first), min(a.second, b.second)};
}

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n;
    cin >> n;
    vector<pair<ll, ll>> tx(n);
    for (auto &[t, x] : tx)
    {
        cin >> t >> x;
        x *= 2;
    }
    sort(tx.begin(), tx.end());
    vector<pair<ll, vector<ll>>> events;
    events.push_back({tx.front().first, {}});
    for (auto &[t, x] : tx)
    {
        if (t != events.back().first) events.push_back({t, {}});
        events.back().second.push_back(x);
    }
    auto merge = [](vector<pair<ll, ll>> &a, vector<pair<ll, ll>> &b) -> void
    {
        vector<pair<ll, ll>> res;
        res.reserve(a.size());
        for (int l = 0, r = 0; l < a.size() && r < b.size();)
        {
            pair<ll, ll> up = inter(a[l], b[r]);
            if (up.second >= up.first) res.push_back(up);
            if (a[l].second > b[r].second) ++r;
            else ++l;
        }
        //assert(res.size() <= max(a.size(), b.size()));
        swap(a, res);
    };
    auto check = [&events, &merge](ll d) -> bool
    {
        ll pt = 0;
        vector<pair<ll, ll>> prev{{0, 0}};
        vector<pair<ll, ll>> segs;
        vector<pair<ll, ll>> nprev;
        for (auto &[t, xs] : events)
        {
            for (int i = 0; i < prev.size(); ++i)
            {
                prev[i].first -= 2 * (t - pt);
                prev[i].second += 2 * (t - pt);
                if (!nprev.empty() && nprev.back().second >= prev[i].first) nprev.back().second = prev[i].second;
                else nprev.push_back(prev[i]);
            }
            swap(prev, nprev);
            nprev.clear();
            segs.clear();
            if (xs.front() - d >= -2 * t) segs.emplace_back(-2 * t, xs.front() - d);
#pragma GCC ivdep
            for (int i = 0; i + 1 < xs.size(); ++i) if (xs[i] + d <= xs[i + 1] - d) segs.emplace_back(xs[i] + d, xs[i + 1] - d);
            if (xs.back() + d <= 2 * t) segs.emplace_back(xs.back() + d, 2 * t);
            merge(prev, segs);
            if (prev.size() > 1000)
            {
                for (int i = 0; i < prev.size(); ++i) nprev.push_back(prev[i]);
            }
            swap(prev, nprev);
            nprev.clear();
            if (prev.empty()) return false;
            pt = t;
        }
        return true;
    };
    ll l = 0, r = 5e9;
    //first that can't
    while (l < r)
    {
        ll m = (l + r) >> 1;
        if (check(m)) l = m + 1;
        else r = m;
    }
    cout << (l - 1) / 2.0;
    return 0;
}
